﻿//////////////////////////////////////////////
// RaytracingPass.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class RenderQueue ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "RenderScenePass.h"

#include "../Dll/DllDefines.h"

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RaytracingPass : public Pass
	{			
		public :

			// Getters
			RenderQueue* getRq () const ;
			Shader* getRaygenMissShader () const ;
			unsigned int getMaxTraceRecursionDepth () const ;
			unsigned int getWidth () const ;
			unsigned int getHeight () const ;
			unsigned int getDepth () const ;

			// Setters
			virtual void setRq (RenderQueue* value) ;
			virtual void setRaygenMissShader (Shader* shader) ;
			virtual void setMaxTraceRecursionDepth (unsigned int value) ;
			void setWidth (unsigned int value) ;
			void setHeight (unsigned int value) ;
			void setDepth (unsigned int value) ;

			// Export / Import
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		protected :

			// Functions
			// Constructor
			RaytracingPass (System* system) noexcept ;

		protected :

			// Attributes
			// Rq
			RenderQueue* _rq ;
			// Shader encodant le raygen et le miss
			Shader* _raygenMissShader ;

			// Dimensions dispatch tracing
			unsigned int _maxTraceRecursionDepth ;
			unsigned int _width ;
			unsigned int _height ;
			unsigned int _depth ;
	} ;
}